<?php
session_start();
require_once('../conexion.php');
require_once('../include/sesiones.php');

?>

<div class="table-responsive">
    <div id="turno">
        <table class="table">
            <thead>
                <tr>
                    <th scope="col">FECHA</th>
                    <th scope="col">TURNO</th>
                    <th scope="col">SERVICIO</th>
                    <th scope="col">TOTAL PAGAR</th>
                    <th scope="col">ESTADO</th>
                    <th scope="col">PROFESIONAL</th>
                    <th scope="col">CANCELAR RESERVA</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $query = "SELECT c.*, u.usu_nombre AS barbero_nombre
                          FROM cotizacion c
                          LEFT JOIN usuario u ON c.vendedor = u.usu_id AND u.empresa_emp_id = '$emp_id'
                          WHERE c.cliente_id = '$clie_id' 
                          AND c.empresa = '$emp_id' 
                          AND c.cot_tipo = 'RESERVA'
                          AND c.cot_estado!='Facturado'
                          AND c.cot_fecha_reserva >= CURDATE()
                          ORDER BY c.cot_fecha_reserva ASC";

                $result = mysqli_query($con, $query) or die(mysqli_error($con));

                while ($row = mysqli_fetch_array($result)) {
                    $cot_id = $row['cot_id'];
                    $cot_fecha = $row['cot_fecha_reserva'];
                    $cot_turno = $row['cot_turno_reserva'];
                    $nom_barbero = $row['barbero_nombre'] ?? 'No disponible';
                    $total = 0;

                    $details_query = "SELECT cotd_cantidad, cotd_precio FROM cotizacion_detalle WHERE cotizacion_cot_id = '$cot_id' AND empresa = '$emp_id'";
                    $details_result = mysqli_query($con, $details_query) or die(mysqli_error($con));
                    while ($detail = mysqli_fetch_array($details_result)) {
                        $total += $detail['cotd_cantidad'] * $detail['cotd_precio'];
                    }

                    $turno_query = "SELECT horas FROM zhop_reserva_usuario WHERE empresa = '$emp_id' AND sucursal = '$suc_id' AND res_usu_id = '$cot_turno'";
                    $turno_result = mysqli_query($con, $turno_query);
                    $turno = ($turno_result && mysqli_num_rows($turno_result) > 0) ? mysqli_fetch_assoc($turno_result)['horas'] : 'No disponible';
                ?>
                    <tr>
                        <td><?php echo $cot_fecha; ?></td>
                        <td style="text-transform: none;">
                            <?php echo $turno; ?>
                        </td>
                        <td>
                            <a data-id="<?php echo $cot_id; ?>" data-bs-toggle="modal" data-bs-target="#modal_box_reserva" class="btn btn_detalle_reserva" title="Ver Detalles">
                                <i class="zmdi zmdi-eye"></i>
                            </a>
                        </td>
                        <td>$<?php echo number_format($total, 0, ",", "."); ?></td>
                        <td><?php echo $row['cot_estado']; ?></td>
                        <td><?php echo $nom_barbero; ?></td>
                        <td>
                            <?php if ($row['cot_estado'] == 'Pendiente') { ?>
                                <a onclick="eliminar('<?php echo $cot_id; ?>')" title="Cancelar" class="btn btn_eliminar">
                                    <i class="zmdi zmdi-delete"></i>
                                </a>
                            <?php } ?>
                        </td>
                    </tr>
                <?php } ?>
            </tbody>
        </table>
    </div>
</div>

<div class="modal fade" id="modal_box_reserva" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <a class="b-close" data-bs-dismiss="modal" aria-label="Close">
                <div id="popup2">
                    <span class="b-close" data-bs-dismiss="modal" aria-label="Close">X</span>
                </div>
            </a>
            <div class="modal_body">
                <div class="container">
                    <div class="row">
                        <div id="resultados_login"></div>
                        <div class="col-lg-12 col-md-12 col-sm-12" id="login_section">
                            <div class="modal_right">
                                <center>
                                    <div class="modal_title mb-10">
                                        <h2>Detalle Servicios</h2>
                                    </div>
                                </center>
                                <div class="modal-body" id="modal_detalle_reserva">
                                    <!-- Aquí se cargará el contenido dinámico -->
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
    $(document).on("click", ".btn_detalle_reserva", function() {
        let id = $(this).data("id");
        $.get("php_tienda/modal_detalle_reserva.php", {
            id: id
        }, function(data) {
            $("#modal_detalle_reserva").html(data);
        });
    });

    function eliminar(cot_id) {
        if (confirm("¿Realmente desea cancelar la reserva?")) {
            $.ajax({
                type: "GET",
                url: "php_cuenta/actualizar_estado.php",
                data: "cot_id=" + cot_id,
                beforeSend: function(objeto) {
                    $('#resultados1').html('<center><img src="./img/ajax-loader.gif"> CARGANDO...</center>');
                },
                success: function(datos) {
                    $("#resultados1").html(datos);
                    loadTurno();
                }
            });
        }
    }
</script>