<?php
session_start();
require_once('../../conexion.php');
require_once('../../include/sesiones.php');
// Declaramos la librería
require  ('vendor/autoload.php');

$desde=$_GET['desde'];
$hasta=$_GET['hasta'];
$proveedor=$_GET['proveedor'];

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

$spread = new Spreadsheet();

$sheet = $spread->getActiveSheet();
$sheet->getStyle('A:Z')->getAlignment()->setHorizontal('center');/* centar contenido de celdas */
$sheet->mergeCells('A1:E1')->mergeCells('A2:E2');/*combinas celdas*/

function cellColor($cells,$color)/* FUNSION PARA COLORES DE CELDA*/
{
    global $sheet;

    $sheet->getStyle($cells)->getFill()
    ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
    ->getStartColor()
    ->setARGB($color);
}

cellColor('A2:E2', 'BDBDBD'); 
cellColor('A1:E1', 'BDBDBD'); 
cellColor('A3:E3', 'FF4D00'); 


$sheet->setCellValue('A1', 'REPORTE VENTAS POR PROVEEDOR Y EMPLEADO')
            ->setCellValue('A2', 'DESDE '.$desde.' HASTA '.$hasta)
            ->setCellValue('A3', 'CANTIDAD')
            ->setCellValue('B3', 'NOMBRE')
            ->setCellValue('C3', 'PROVEEDOR')
            ->setCellValue('D3', 'COSTO U')
            ->setCellValue('E3', 'COSTO T');

            //Ancho de las columnas
$sheet->getColumnDimension('A')->setWidth(5);   
$sheet->getColumnDimension('B')->setWidth(20);  
$sheet->getColumnDimension('C')->setWidth(20); 
$sheet->getColumnDimension('D')->setWidth(20); 
$sheet->getColumnDimension('E')->setWidth(20);

    $cel=4;//Numero de fila donde empezara a crear  el reporte

$hasta1 = strtotime($hasta."+ 1 days");
date("Y-m-d",$hasta1) . "\n";
$hastaf=date("Y-m-d",$hasta1) . "\n";

if ($proveedor==0) 
{
    $sql1=mysqli_query($con, "SELECT * from proveedor where empresa='$empresa' order by pro_nombre asc");
}
else
{
    $sql1=mysqli_query($con, "SELECT * from proveedor where pro_id='$proveedor' and empresa='$empresa' order by pro_nombre asc");
}

if(empty($_GET['1'])) { $uno='0'; } else { $uno=$_GET['1']; }
if(empty($_GET['2'])) { $dos='0'; } else { $dos=$_GET['2']; }
if(empty($_GET['3'])) { $tres='0'; } else { $tres=$_GET['3']; }
if(empty($_GET['4'])) { $cuatro='0'; } else { $cuatro=$_GET['4']; }
if(empty($_GET['5'])) { $cinco='0'; } else { $cinco=$_GET['5']; }
if(empty($_GET['6'])) { $seis='0'; } else { $seis=$_GET['6']; }
if(empty($_GET['7'])) { $siete='0'; } else { $siete=$_GET['7']; }
if(empty($_GET['8'])) { $ocho='0'; } else { $ocho=$_GET['8']; }
if(empty($_GET['9'])) { $nueve='0'; } else { $nueve=$_GET['9']; }
if(empty($_GET['10'])) { $diez='0'; } else { $diez=$_GET['10']; }
if(empty($_GET['11'])) { $once='0'; } else { $once=$_GET['11']; }
if(empty($_GET['12'])) { $doce='0'; } else { $doce=$_GET['12']; }
if(empty($_GET['13'])) { $trece='0'; } else { $trece=$_GET['13']; }
if(empty($_GET['14'])) { $catorce='0'; } else { $catorce=$_GET['14']; }


while ($cos=mysqli_fetch_array($sql1))
{
    $pro_nombre=$cos['pro_nombre'];  
    $pro_id=$cos['pro_id'];
    $sumador_total=0;
    $sql=mysqli_query($con, "SELECT *,sum(vend_cantidad_dev) as vend_cantidad_dev from venta_detalle d,ventas v,articulos a 
    where d.ventas_ven_id=v.ven_id and v.ven_estado<>'anulada' and v.ven_fecha BETWEEN '$desde' AND '$hasta' 
    and v.sucursal='$sucursal' and v.empresa='$empresa' and a.art_id=d.vend_art_id and a.proveedor_pro_id='$pro_id' and vendedor IN($uno, $dos, $tres, $cuatro, $cinco, $seis, $siete, $ocho, $nueve, $diez, $once, $doce, $trece, $catorce) group by vend_art_id  
    order by proveedor_pro_id,vend_nombre asc "); 

    while ($row=mysqli_fetch_array($sql))
    {
        $vend_art_id=$row['vend_art_id'];
        $vend_referencia=$row['vend_referencia'];
        $vend_nombre=($row['vend_nombre']);
        $vend_cantidad=$row['vend_cantidad_dev'];
        $vend_costo=$row['vend_costo'];
        $vend_precio_real=($row['vend_precio_real']);
        $ventas_ven_id=$row['ventas_ven_id'];
        $total= $vend_cantidad*$vend_precio_real;

         $sumador_total+=$total;//Sumador

        $a="A".$cel;
        $b="B".$cel;
        $c="C".$cel;
        $d="D".$cel;
        $e="E".$cel;
       
       
        // Agregar datos
        $sheet
        ->setCellValue($a, $vend_cantidad)
        ->setCellValue($b, $vend_nombre)
        ->setCellValue($c, $pro_nombre)
        ->setCellValue($d, number_format($vend_costo,0))
        ->setCellValue($e, number_format($total,0));
            
             $cel+=1;
    }  


    if($sumador_total<>0)
    {
        $d="D".$cel;
        $e="E".$cel;


        // Agregar datos
        $sheet->mergeCells("A".($cel).":C".($cel))
        ->setCellValue($d, 'TOTAL GENERAL')
        ->setCellValue($e, number_format($sumador_total,0));

        cellColor('A'.$cel.':E'.$cel, 'BDBDBD');

        $cel+=1;
    } 

}


// Redirigir la salida al navegador web de un cliente ( Excel5 )
header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment;filename="REPORTE VENTAS POR PROVEEDOR Y EMPLEADO.xlsx"');
header('Cache-Control: max-age=0');
// Si usted está sirviendo a IE 9 , a continuación, puede ser necesaria la siguiente
header('Cache-Control: max-age=1');

$writer = new Xlsx($spread);
$writer->save('php://output');
exit;
/*
$fileName="Descarga_excel.xlsx";
# Crear un "escritor"
$writer = new Xlsx($spread);
# Le pasamos la ruta de guardado

header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="'. urlencode($fileName).'"');
$writer->save('php://output');
?>*/
?>