<?php
session_start();
require_once('../../conexion.php');
require_once('../../include/sesiones.php');
// Declaramos la librería
require  ('vendor/autoload.php');

$desde=$_GET['desde'];
$hasta=$_GET['hasta'];
$usu_id=$_GET['empleadoo'];

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

$spread = new Spreadsheet();

$sheet = $spread->getActiveSheet();
$sheet->getStyle('A:Z')->getAlignment()->setHorizontal('center');/* centar contenido de celdas */
$sheet->mergeCells('A1:E1')->mergeCells('A2:E2');/*combinas celdas*/

function cellColor($cells,$color)/* FUNSION PARA COLORES DE CELDA*/
{
    global $sheet;

    $sheet->getStyle($cells)->getFill()
    ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
    ->getStartColor()
    ->setARGB($color);
}

cellColor('A2:E2', 'BDBDBD'); 
cellColor('A1:E1', 'BDBDBD'); 
cellColor('A3:E3', 'FF4D00'); 


$sheet->setCellValue('A1', 'REPORTE VENTAS POR EMPLEADO')
            ->setCellValue('A2', 'DESDE '.$desde.' HASTA '.$hasta)
            ->setCellValue('A3', 'REF')
            ->setCellValue('B3', 'CANTIDAD')
            ->setCellValue('C3', 'PRODUCTO')
            ->setCellValue('D3', 'COSTO U')
            ->setCellValue('E3', 'COSTO T');

            //Ancho de las columnas
$sheet->getColumnDimension('A')->setWidth(10);   
$sheet->getColumnDimension('B')->setWidth(10);  
$sheet->getColumnDimension('C')->setWidth(60); 
$sheet->getColumnDimension('D')->setWidth(20); 
$sheet->getColumnDimension('E')->setWidth(10);


    $cel=4;//Numero de fila donde empezara a crear  el reporte

$hasta1 = strtotime($hasta."+ 1 days");
date("Y-m-d",$hasta1) . "\n";
$hastaf=date("Y-m-d",$hasta1) . "\n";

$sumador_articulos=0;
$desc=0;

$sql=mysqli_query($con, "SELECT *,sum(vend_cantidad_dev) as vend_cantidad_dev,  AVG(vend_precio_real) as pv from venta_detalle d,ventas v,articulos a 
where d.ventas_ven_id=v.ven_id and v.ven_estado<>'anulada' and  v.ven_fecha BETWEEN '$desde' AND '$hasta' 
and v.sucursal='$sucursal' and v.empresa='$empresa' and a.art_id=d.vend_art_id and v.vendedor ='$usu_id' group by d.vend_art_id  
order by d.vend_nombre asc "); 

while ($row=mysqli_fetch_array($sql))
{
    $vend_referencia=$row['vend_referencia'];
    $vend_nombre=$row['vend_nombre'];
    $vend_cantidad=$row['vend_cantidad_dev'];
    $vend_precio=$row['vend_precio'];
    $vend_iva=$row['vend_iva'];
    $vend_descuento=$row['vend_desc'];
    $ivaf=$vend_iva/100;
    $precio_total=$vend_precio*$vend_cantidad;
    $descuento=($vend_descuento/100)*$precio_total;
    $iva=$vend_precio*$ivaf;
    $sin_iva=$vend_precio-$iva;
    $sumador_articulos+=$precio_total-$descuento;//Sumador
    $desc+=$descuento;

    $a="A".$cel;
    $b="B".$cel;
    $c="C".$cel;
    $d="D".$cel;
    $e="E".$cel;
   
   
    // Agregar datos
    $sheet
    ->setCellValue($a, $vend_referencia)
    ->setCellValue($b, $vend_cantidad)
    ->setCellValue($c, $vend_nombre)
    ->setCellValue($d, number_format($vend_precio,0))
    ->setCellValue($e, number_format($precio_total,0));
        
         $cel+=1;
}  


$sumador_combos=0;
$sqlc=mysqli_query($con, "SELECT *,sum(d.combo_cantidad) as sum_combo_cantidad from venta_detalle_combo d, ventas v, combos c 
where d.ven_id=v.ven_id and v.ven_estado<>'anulada' and  v.ven_fecha BETWEEN '$desde' AND '$hasta' 
and v.sucursal='$sucursal' and v.empresa='$empresa' and d.combo_id=c.com_id and vendedor ='$usu_id' group by d.combo_id  
order by d.combo_nombre asc "); 
while ($rowc=mysqli_fetch_array($sqlc))
{
   
    $combo_cantidad=$rowc["sum_combo_cantidad"];
    $combo_precio=$rowc['combo_precio'];
    $combo_nombre=$rowc['combo_nombre'];       
    $precio_total_c=$combo_cantidad*$combo_precio;
    $sumador_combos+=$precio_total_c;

    $a="A".$cel;
    $b="B".$cel;
    $c="C".$cel;
    $d="D".$cel;
    $e="E".$cel;
   
   
    // Agregar datos
    $sheet
    ->setCellValue($a, '')
    ->setCellValue($b, $combo_cantidad)
    ->setCellValue($c, $combo_nombre)
    ->setCellValue($d, number_format($combo_precio,0))
    ->setCellValue($e, number_format($precio_total_c,0));
    
     $cel+=1;

}

if($sumador_articulos<>0)
{
    $d="D".$cel;
    $e="E".$cel;
   
   
    // Agregar datos
    $sheet->mergeCells("A".($cel).":C".($cel))
    ->setCellValue($d, 'TOTAL GENERAL')
    ->setCellValue($e, number_format($sumador_articulos+$sumador_combos,0));

    cellColor('A'.$cel.':E'.$cel, 'BDBDBD');
} 


// Redirigir la salida al navegador web de un cliente ( Excel5 )
header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment;filename="REPORTE VENTAS POR EMPLEADO.xlsx"');
header('Cache-Control: max-age=0');
// Si usted está sirviendo a IE 9 , a continuación, puede ser necesaria la siguiente
header('Cache-Control: max-age=1');

$writer = new Xlsx($spread);
$writer->save('php://output');
exit;
/*
$fileName="Descarga_excel.xlsx";
# Crear un "escritor"
$writer = new Xlsx($spread);
# Le pasamos la ruta de guardado

header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="'. urlencode($fileName).'"');
$writer->save('php://output');
?>*/
?>