<?php
session_start();
require_once('../../conexion.php');
require_once('../../include/sesiones.php');
// Declaramos la librería
require  ('vendor/autoload.php');

$desde=$_GET['desde'];
$hasta=$_GET['hasta'];

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

$spread = new Spreadsheet();

$sheet = $spread->getActiveSheet();
$sheet->getStyle('A:Z')->getAlignment()->setHorizontal('center');/* centar contenido de celdas */
$sheet->mergeCells('A1:F1')->mergeCells('A2:F2');/*combinas celdas*/

function cellColor($cells,$color)/* FUNSION PARA COLORES DE CELDA*/
{
    global $sheet;

    $sheet->getStyle($cells)->getFill()
    ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
    ->getStartColor()
    ->setARGB($color);
}

cellColor('A2:F2', 'BDBDBD'); 
cellColor('A1:F1', 'BDBDBD'); 
cellColor('A3:F3', 'FFFFF'); 


$sheet->setCellValue('A1', 'REPORTE VENTAS IVA DETALLADO')
            ->setCellValue('A2', 'DESDE '.$desde.' HASTA '.$hasta);

            //Ancho de las columnas
$sheet->getColumnDimension('A')->setWidth(20);   
$sheet->getColumnDimension('B')->setWidth(40);  
$sheet->getColumnDimension('C')->setWidth(20); 
$sheet->getColumnDimension('D')->setWidth(20); 
$sheet->getColumnDimension('E')->setWidth(20);
$sheet->getColumnDimension('F')->setWidth(20);


    $cel=3;//Numero de fila donde empezara a crear  el reporte

$hasta1 = strtotime($hasta."+ 1 days");
date("Y-m-d",$hasta1) . "\n";
$hastaf=date("Y-m-d",$hasta1) . "\n";

$base_global=0;
$iva_global=0;
$total_global=0;

$sqliva=mysqli_query($con,"SELECT * from iva where empresa='$empresa' ") or die(mysqli_error($con)); 
while ($iva=mysqli_fetch_array($sqliva))
{
    $iva_porcentaje=$iva['iva_porcentaje']; //19
    $iva0_t=$iva_porcentaje/100; //0.19
    $ivaf_t=1+$iva0_t; //1.19
/*
    $pdf->SetFillColor(255,90,0);
    $pdf->Cell(190,4,'IVA '.$iva_porcentaje.' %',1,0,'C',1);
    $pdf->Ln(); 
    $pdf->SetFillColor(255,200,0);
    $pdf->SetFont('Arial','B',8);
    $pdf->Cell(25,4,'CODIGO',1,0,'C',1);
    $pdf->Cell(95,4,'NOMBRE',1,0,'C',1);
    $pdf->Cell(15,4,'CANT',1,0,'C',1);
    $pdf->Cell(20,4,'BASE',1,0,'C',1);
    $pdf->Cell(15,4,'IVA $',1,0,'C',1);
    $pdf->Cell(20,4,'TOTAL',1,0,'C',1);
    $pdf->Ln(); */

    $a="A".$cel;
    $f="F".$cel;
    // Agregar datos
    $sheet->mergeCells("A".($cel).":F".($cel));
    $cel+=1;


    $a="A".$cel;
    // Agregar datos
    $sheet->mergeCells("A".($cel).":F".($cel))
    ->setCellValue($a, 'IVA '.$iva_porcentaje.' %');
   
    cellColor('A'.$cel.':F'.$cel, 'BDBDBD');
    $cel+=1;



    $a="A".$cel;
    $b="B".$cel;
    $c="C".$cel;
    $d="D".$cel;
    $e="E".$cel;
    $f="F".$cel;
              
    // Agregar datos
    $sheet->setCellValue($a, 'CODIGO')
    ->setCellValue($b, 'NOMBRE')
    ->setCellValue($c, 'CANT')
    ->setCellValue($d, 'BASE')
    ->setCellValue($e, 'IVA $')
    ->setCellValue($f, 'TOTAL');


    /* color a las celdas con funsion*/            
    cellColor('A'.$cel.':F'.$cel, 'FF4D00');

  
   $cel+=1;

    $total_base_por_iva=0;
    $total_iva_por_iva=0;
    $total_por_iva=0;


if ($reporte=='pos')
{
    $registros=mysqli_query($con,"SELECT *,sum(vd.vend_cantidad) as can, AVG(vd.vend_precio_real) as pc  FROM ventas v, venta_detalle vd  where v.ven_tipo='$reporte' AND  v.ven_id =vd.ventas_ven_id  and vd.vend_iva='$iva_porcentaje' and v.ven_fecha BETWEEN '$desde' AND '$hasta' and v.empresa='$empresa' and v.sucursal='$sucursal' and v.ven_estado<>'anulada'  group by vd.vend_art_id, vd.vend_precio asc") or die(mysqli_error($con));
} 
else if ($reporte=='electronica')
{
    $registros=mysqli_query($con,"SELECT *,sum(vd.vend_cantidad) as can, AVG(vd.vend_precio_real) as pc  FROM ventas v, venta_detalle vd  where v.ven_tipo='$reporte' AND v.estado_dian='Aprobada' and v.ven_id =vd.ventas_ven_id  and vd.vend_iva='$iva_porcentaje' and v.ven_fecha BETWEEN '$desde' AND '$hasta' and v.empresa='$empresa' and v.sucursal='$sucursal' and v.ven_estado<>'anulada' group by vd.vend_art_id, vd.vend_precio asc") or die(mysqli_error($con));

}
 else
{
    $registros=mysqli_query($con,"SELECT *,sum(vd.vend_cantidad) as can, AVG(vd.vend_precio_real) as pc  FROM ventas v, venta_detalle vd  where v.ven_id =vd.ventas_ven_id  and vd.vend_iva='$iva_porcentaje' and v.ven_fecha BETWEEN '$desde' AND '$hasta' and v.empresa='$empresa' and v.sucursal='$sucursal' and v.ven_estado<>'anulada'  group by vd.vend_art_id, vd.vend_precio asc") or die(mysqli_error($con));
}




    


    while ($rew=mysqli_fetch_array($registros))
    {
        $vend_referencia=$rew['vend_referencia'];
        $vend_nombre=$rew['vend_nombre'];
        $vend_cantidad=$rew['can'];
        $vend_precio=$rew['pc']; //1.000.000
        $vend_iva=$rew['vend_iva']; //19%
        $vend_descuento=$rew['vend_desc']; //10%

        $precio_total_item=$vend_precio*$vend_cantidad;//precio normal 1.000.000
        $precio_total_sin_iva_item=($vend_precio/$ivaf_t)*$vend_cantidad; //precio sin iva  840.336
        $descuento_item=($vend_descuento/100)*$precio_total_sin_iva_item; //descuento_item 84.033
        $total_iva_item=$precio_total_sin_iva_item*$iva0_t; // total iva  159.336

        $total_base_por_iva+=$precio_total_sin_iva_item;
        $total_iva_por_iva+=$total_iva_item;
        $total_por_iva+=$precio_total_item;
/*
        $pdf->SetFillColor(255,255,255);
        $pdf->SetFont('Arial','B',7);
        $pdf->Cell(25,4,$vend_referencia,1,0,'C',1);
        $pdf->Cell(95,4,utf8_decode($vend_nombre),1,0,'C',1);
        $pdf->Cell(15,4,$vend_cantidad,1,0,'C',1);
        $pdf->Cell(20,4,number_format($precio_total_sin_iva_item),1,0,'R',1);
        $pdf->Cell(15,4,number_format($total_iva_item,0),1,0,'R',1);
        $pdf->Cell(20,4,number_format($precio_total_item,0),1,0,'R',1);
        $pdf->Ln();
*/
        $a="A".$cel;
        $b="B".$cel;
        $c="C".$cel;
        $d="D".$cel;
        $e="E".$cel;
        $f="F".$cel;
           
        // Agregar datos
        $sheet
        ->setCellValue($a, $vend_referencia)
        ->setCellValue($b, $vend_nombre)
        ->setCellValue($c, $vend_cantidad)
        ->setCellValue($d, number_format($precio_total_sin_iva_item))
        ->setCellValue($e, number_format($total_iva_item,0))
        ->setCellValue($f, number_format($precio_total_item,0));

        
         $cel+=1; 

    }

    $base_global+=$total_base_por_iva;
    $iva_global+=$total_iva_por_iva;
    $total_global+=$total_por_iva;


  /*  $pdf->SetFillColor(0,200,255);
    $pdf->SetFont('Arial','B',7);
    $pdf->Cell(135,4,'',1,0,'C',1);
    $pdf->Cell(20,4,number_format($total_base_por_iva,0),1,0,'R',1);
    $pdf->Cell(15,4,number_format($total_iva_por_iva,0),1,0,'R',1);
    $pdf->Cell(20,4,number_format($total_por_iva,0),1,0,'R',1);
   
    $pdf->Ln(); 
    $pdf->Ln(); */

    $d="D".$cel;
    $e="E".$cel;
    $f="F".$cel;

    // Agregar datos
    $sheet->mergeCells("A".($cel).":B".($cel))
    ->setCellValue($d, number_format($total_base_por_iva,0))
    ->setCellValue($e, number_format($total_iva_por_iva,0))
    ->setCellValue($f, number_format($total_por_iva,0));


    cellColor('A'.$cel.':F'.$cel, 'BDBDBD');
    $cel+=1;

}


   /* $pdf->SetFillColor(0,255,0);
    $pdf->SetFont('Arial','B',7);
    $pdf->Cell(135,4,'TOTAL GENERAL',1,0,'C',1);
    $pdf->Cell(20,4,number_format($base_global,0),1,0,'R',1);
    $pdf->Cell(15,4,number_format($iva_global,0),1,0,'R',1);
    $pdf->Cell(20,4,number_format($total_global,0),1,0,'R',1);
   
    $pdf->Ln(); 
*/
    $a="A".$cel;
    $f="F".$cel;

    // Agregar datos
    $sheet->mergeCells("A".($cel).":F".($cel));
    $cel+=1;


    $c="C".$cel;
    $d="D".$cel;
    $e="E".$cel;
    $f="F".$cel;

    // Agregar datos
    $sheet->mergeCells("A".($cel).":B".($cel))
    ->setCellValue($c, 'TOTAL GENERAL')
    ->setCellValue($d, number_format($base_global,0))
    ->setCellValue($e, number_format($iva_global,0))
    ->setCellValue($f, number_format($total_global,0));


    cellColor('A'.$cel.':F'.$cel, 'DA8869');


// Redirigir la salida al navegador web de un cliente ( Excel5 )
header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment;filename="REPORTE VENTAS IVA DETALLADO.xlsx"');
header('Cache-Control: max-age=0');
// Si usted está sirviendo a IE 9 , a continuación, puede ser necesaria la siguiente
header('Cache-Control: max-age=1');

$writer = new Xlsx($spread);
$writer->save('php://output');
exit;
/*
$fileName="Descarga_excel.xlsx";
# Crear un "escritor"
$writer = new Xlsx($spread);
# Le pasamos la ruta de guardado

header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="'. urlencode($fileName).'"');
$writer->save('php://output');
?>*/
?>