<?php
session_start();
require_once('../../conexion.php');
require_once('../../include/sesiones.php');
// Declaramos la librería
require  ('vendor/autoload.php');

$desde=$_GET['desde'];
$hasta=$_GET['hasta'];
$art_proveedor=$_GET['proveedor'];

$total_compras=0;
$iva_global=0;
$cargo_global=0;
$base=0;

if($art_proveedor<>'0')
{
    $registros=mysqli_query($con,"SELECT * FROM compras  where proveedor_pro_id='$art_proveedor' and  com_fecha BETWEEN '$desde' AND '$hasta' and empresa='$empresa'   order by com_id desc") or die(mysqli_error($con));
}
else 
{
    $registros=mysqli_query($con,"SELECT * FROM compras  where  com_fecha BETWEEN '$desde' AND '$hasta' and empresa='$empresa'   order by com_id desc") or die(mysqli_error($con));
}


use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

$spread = new Spreadsheet();

$sheet = $spread->getActiveSheet();
$sheet->getStyle('A:Z')->getAlignment()->setHorizontal('center');/* centar contenido de celdas */
$sheet->mergeCells('A1:G1')->mergeCells('A2:G2');/*combinas celdas*/

function cellColor($cells,$color)/* FUNSION PARA COLORES DE CELDA*/
{
    global $sheet;

    $sheet->getStyle($cells)->getFill()
    ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
    ->getStartColor()
    ->setARGB($color);
}

cellColor('A2:G2', 'BDBDBD'); 
cellColor('A1:G1', 'BDBDBD'); 
cellColor('A3:G3', 'FF4D00'); 


$sheet->setCellValue('A1', 'REPORTE COMPRAS TOTAL')
        ->setCellValue('A2', 'DESDE '.$desde.' HASTA '.$hasta)
        ->setCellValue('A3', 'N')
        ->setCellValue('B3', 'FECHA')
        ->setCellValue('C3', 'PROVEEDOR')
        ->setCellValue('D3', 'BASE')
        ->setCellValue('E3', 'IVA')
        ->setCellValue('F3', 'CARGO')
        ->setCellValue('G3', 'TOTAL');


            //Ancho de las columnas
$sheet->getColumnDimension('A')->setWidth(20);   
$sheet->getColumnDimension('B')->setWidth(20);  
$sheet->getColumnDimension('C')->setWidth(20); 
$sheet->getColumnDimension('D')->setWidth(20); 
$sheet->getColumnDimension('E')->setWidth(20);
$sheet->getColumnDimension('F')->setWidth(20);
$sheet->getColumnDimension('G')->setWidth(20);


    $cel=4;//Numero de fila donde empezara a crear  el reporte

$hasta1 = strtotime($hasta."+ 1 days");
date("Y-m-d",$hasta1) . "\n";
$hastaf=date("Y-m-d",$hasta1) . "\n";
while ($reg=mysqli_fetch_array($registros))
{
    $com_id=$reg['com_id'];
    $sumador_total=0;
    $neto=0;
    $total_retencion=0;
    $total_iva=0;
    $total_cargo_adicional=0;
    $sql=mysqli_query($con, "SELECT * from compra_detalle where compras_com_id='$com_id' and empresa='$empresa'");
    while ($rew=mysqli_fetch_array($sql))
    {
        $comd_cantidad=$rew['comd_cantidad'];
        $comd_precio=$rew['comd_precio'];
        $comd_iva=$rew['comd_iva'];
        $precio_total=$comd_precio*$comd_cantidad;
        $iva=($precio_total*$comd_iva)/100;
        $neto+=$precio_total;//Sumador
        $comd_flete=$rew['comd_flete'];
        $cargo_adicional=$comd_flete*$comd_cantidad;
        $sumador_total+=$precio_total;//Sumador
        $total_iva+=$iva;//Sumador
        $total_cargo_adicional+=$cargo_adicional;
    }
    $sql=mysqli_query($con, "SELECT sum(coab_abono) as total from compra_abonos where compras_com_id='$com_id' and empresa='$empresa'");
    $sql1=mysqli_fetch_array($sql);
    $total=$sql1['total'];
    $saldo=$sumador_total-$total;

    $ret=mysqli_query($con,"SELECT * FROM retencion_compra where empresa='$empresa' and compras_com_id='$com_id'") or die(mysqli_error($con)); 
    $rets=mysqli_fetch_array($ret);
    $total_retencion=($ret_porcentaje=$rets['ret_porcentaje']/100)*$neto;


    $total_compras+=$sumador_total-$total_retencion;
    $iva_global+=$total_iva;
    $cargo_global+=$total_cargo_adicional;
    $base+=$neto;

    
        $a="A".$cel;
        $b="B".$cel;
        $c="C".$cel;
        $d="D".$cel;
        $e="E".$cel;
        $f="F".$cel;
        $g="G".$cel;


        $sheet
        ->setCellValue($a, $reg['com_n_compra'])
        ->setCellValue($b, $reg['com_fecha'])
        ->setCellValue($c, utf8_decode($reg['proveedor_nombre']))
        ->setCellValue($d, number_format($neto,0))
        ->setCellValue($e, number_format($total_iva,0))
        ->setCellValue($f, number_format($total_cargo_adicional,0))
        ->setCellValue($g, number_format($sumador_total+$total_cargo_adicional-$total_retencion+$total_iva,0));

        $cel+=1;
}

        
       
        $b="B".$cel;
        $c="C".$cel;
        $d="D".$cel;
        $e="E".$cel;
        $f="F".$cel;
        $g="G".$cel;

        // Agregar datos
        $sheet->mergeCells("A".($cel).":B".($cel))
        ->setCellValue($c, 'TOTALES')
        ->setCellValue($d, number_format($base,0))
        ->setCellValue($e, number_format($iva_global,0))
        ->setCellValue($f, number_format($cargo_global,0))
        ->setCellValue($g, number_format($base+$cargo_global+$iva_global,0));


          cellColor('A'.$cel.':G'.$cel, 'BDBDBD');


// Redirigir la salida al navegador web de un cliente ( Excel5 )
header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment;filename="REPORTE COMPRAS TOTAL.xlsx"');
header('Cache-Control: max-age=0');
// Si usted está sirviendo a IE 9 , a continuación, puede ser necesaria la siguiente
header('Cache-Control: max-age=1');

$writer = new Xlsx($spread);
$writer->save('php://output');
exit;
/*
$fileName="Descarga_excel.xlsx";
# Crear un "escritor"
$writer = new Xlsx($spread);
# Le pasamos la ruta de guardado

header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="'. urlencode($fileName).'"');
$writer->save('php://output');
?>*/
?>